/****************************************************************************/
/* FILE NAME: main.c                       COPYRIGHT (c) Freescale 2006   	*/
/*                                                All Rights Reserved     	*/
/* DESCRIPTION:                                                           	*/
/* This is the main file for the MPC5561 Multi-Module Test Phase 2 (MMTP2).	*/
/* This is the required setup for the slave node. The main file 			*/
/* configures the modules used and then starts the test. 					*/
/*========================================================================	*/
/* REV      AUTHOR        DATE        DESCRIPTION OF CHANGE               	*/
/* ---   -----------    ----------    ---------------------               	*/
/* 0.1	  D.Paterson	01/Feb/07    Initial Version					  	*/
/****************************************************************************/
#include "mpc5561.h"
#include "typedefs.h"
#include "fs_gpio.h"     /* GPIO API for the MPC5500 family */

extern vuint32_t DSPI_RXQUEUE[2];  		// Set up a result queue for DSPI B  
extern vuint32_t DSPI_RXQUEUE1[2];  	// Set up a result queue for DSPI C  
extern int DSPIB_complete; 
extern int DSPIC_complete;  

void config_pins();
void setup_FMPLL();
void clear_TCD(void);

/**************************************************************************/
/* FUNCTION     : main		  											  */
/* PURPOSE      : Initializes the DSPI and FlexCAN modules				  */
/*				and performs the communication							  */
/**************************************************************************/
void main (void) {
	
	setup_FMPLL();    		// Setup the PLL
	clear_TCD();							// Clear SRAM located eDMA TCD memory 
	config_pins();
	initDMA();				// Setup eDMA for DSPI operation
	initDSPI();				// Initialize DSPI B & C
	
	flexCAN_A_config();		// Setup FlexCAN A module
	flexCAN_C_config(); 	// Setup FlexCAN C module
	
	DSPIB_complete = 0;				// Initially set DSPIB_complete variable
	DSPIC_complete = 0;				// Initially set DSPIC_complete variable
	
	while(1)				// Loop forever
	{
	SIU.GPDO[203].R = 0;	// Set test LEDs to OFF
    SIU.GPDO[204].R = 0;
    SIU.GPDO[206].R = 0;
    SIU.GPDO[207].R = 0;
    
	DSPI_test();			// Perform DSPI communication
	
	flexCAN_test();			// Perform FlexCAN communication
	}

} 

/**************************************************************************/
/* FUNCTION     : setup_FMPLL											  */
/* PURPOSE      : Configures FMPLL to 128 MHz                             */
/**************************************************************************/
void setup_FMPLL(void) {
	
	FMPLL.SYNCR.R = 0x46000000;		// 128MHz for Lance / Tiger
	
	// Wait for FMPLL to lock
	while(FMPLL.SYNSR.B.LOCK != 1);
	
	//Setup ENGCLK (Source = 40MHz crystal)
	SIU.PCR[214].B.OBE = 0x1;
	SIU.ECCR.R = 0x0000FA81;
}

/**************************************************************************/
/* FUNCTION     : config_pins		  									  */
/* PURPOSE      : Configures DSPI & C pins, FlexCAN pins and LED ports	  */
/**************************************************************************/
void config_pins()
{
  fs_gpio_config( FS_GPIO_SOUTB, FS_GPIO_PRIMARY_FUNCTION   + FS_GPIO_MAXIMUM_SLEW_RATE + FS_GPIO_OUTPUT_DRAIN_DISABLE + FS_GPIO_READBACK_ENABLE + FS_GPIO_OUTPUT_BUFFER_ENABLE);       //SOUTB
  fs_gpio_config( FS_GPIO_SCKB,  FS_GPIO_PRIMARY_FUNCTION   + FS_GPIO_MAXIMUM_SLEW_RATE + FS_GPIO_OUTPUT_DRAIN_DISABLE                           + FS_GPIO_INPUT_BUFFER_ENABLE);        //SCKB 
  fs_gpio_config( FS_GPIO_PCSB0, FS_GPIO_PRIMARY_FUNCTION   + FS_GPIO_MAXIMUM_SLEW_RATE + FS_GPIO_OUTPUT_DRAIN_DISABLE                           + FS_GPIO_INPUT_BUFFER_ENABLE);        //PCSB0
  fs_gpio_config( FS_GPIO_SINB,  FS_GPIO_PRIMARY_FUNCTION   + FS_GPIO_MAXIMUM_SLEW_RATE + FS_GPIO_OUTPUT_DRAIN_DISABLE                           + FS_GPIO_INPUT_BUFFER_ENABLE);        //SINB 
  fs_gpio_config( FS_GPIO_PCSB3, FS_GPIO_ALTERNATE_FUNCTION + FS_GPIO_MAXIMUM_SLEW_RATE + FS_GPIO_OUTPUT_DRAIN_DISABLE                           + FS_GPIO_INPUT_BUFFER_ENABLE);        //SINC 
  fs_gpio_config( FS_GPIO_PCSB2, FS_GPIO_ALTERNATE_FUNCTION + FS_GPIO_MAXIMUM_SLEW_RATE + FS_GPIO_OUTPUT_DRAIN_DISABLE + FS_GPIO_READBACK_ENABLE + FS_GPIO_OUTPUT_BUFFER_ENABLE);       //SOUTC
  fs_gpio_config( FS_GPIO_PCSB4, FS_GPIO_ALTERNATE_FUNCTION + FS_GPIO_MAXIMUM_SLEW_RATE + FS_GPIO_OUTPUT_DRAIN_DISABLE                           + FS_GPIO_INPUT_BUFFER_ENABLE);        //SCKC 
  fs_gpio_config( FS_GPIO_PCSB5, FS_GPIO_ALTERNATE_FUNCTION + FS_GPIO_MAXIMUM_SLEW_RATE + FS_GPIO_OUTPUT_DRAIN_DISABLE                           + FS_GPIO_INPUT_BUFFER_ENABLE);        //PCSC0

  //FlexCAN A & C pin setup
  SIU.PCR[83].R = 0x0633;     //CNTXA
  SIU.PCR[84].R = 0x0510;     //CNRXA
      
  SIU.PCR[87].R = 0x0633;     //CNTXC
  SIU.PCR[88].R = 0x0510;     //CNRXC
  
  //Setup LED pins
  /* OBE=ON, IBE=OFF, Primary mode*/
  SIU.PCR[206].R = 0x0200;
  /* OBE=ON, IBE=OFF, Primary mode*/
  SIU.PCR[207].R = 0x0200;	
  /* OBE=ON, IBE=OFF, Primary mode*/
  SIU.PCR[203].R = 0x0200;	
  /* OBE=ON, IBE=OFF, Primary mode*/
  SIU.PCR[204].R = 0x0200;

  }
  
/**************************************************************************/
/* FUNCTION     : clear_TCD											      */
/* PURPOSE      : Clear SRAM located eDMA TCD memory                      */
/**************************************************************************/
void clear_TCD(void) {
	
	// Clear SRAM located eDMA TCD memory 
	// - Ensures correct operation of the eDMA module
	
	 int i=0;
	 
	 for(i=0;i<1024;i=i+4)
	 {
	 	*(unsigned int*)(0xFFF45000+i) = 0x00000000; 
	 }
	 
 }
